/*
 * Decompiled with CFR 0.152.
 */
package pl.amon.moretinygates.blocks;

import com.dannyandson.tinygates.blocks.AbstractGateBlock;
import com.dannyandson.tinygates.blocks.AbstractGateBlockEntity;
import com.dannyandson.tinygates.blocks.GateBlockRenderer;
import com.dannyandson.tinygates.blocks.Side;
import com.dannyandson.tinygates.items.GateBlockItem;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public abstract class GateBlock {
    public RegistryObject<VariantBlock> block;
    public RegistryObject<Item> item;
    public RegistryObject<BlockEntityType<VariantBlockEntity>> entity;

    public abstract int logic(int var1, int var2);

    public GateBlock(String name, DeferredRegister<Item> ITEMS, DeferredRegister<Block> BLOCKS, DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES) {
        this.block = BLOCKS.register(name + "_block", () -> new VariantBlock(name));
        this.item = ITEMS.register(name + "_item", () -> new GateBlockItem((Block)this.block.get()));
        this.entity = BLOCK_ENTITIES.register(name + "_block", this.createSupplier(name, this.block));
    }

    public int runLogicOnSites(int left, int right, int back, int front) {
        return this.logic(left, right);
    }

    public void registerBlockEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)this.entity.get(), GateBlockRenderer::new);
    }

    public Supplier<? extends BlockEntityType<VariantBlockEntity>> createSupplier(String name, RegistryObject<VariantBlock> block) {
        return () -> BlockEntityType.Builder.m_155273_((pos, state) -> new VariantBlockEntity(pos, state, name), (Block[])new Block[]{(Block)block.get()}).m_58966_(null);
    }

    public static ResourceLocation getOnTexture(String name) {
        return new ResourceLocation("moretinygates", "block/" + name + "_on");
    }

    public static ResourceLocation getOffTexture(String name) {
        return new ResourceLocation("moretinygates", "block/" + name + "_off");
    }

    public class VariantBlockEntity
    extends AbstractGateBlockEntity {
        String name;

        public VariantBlockEntity(BlockPos pos, BlockState state, String name) {
            super((BlockEntityType)GateBlock.this.entity.get(), pos, state);
            this.name = name;
        }

        public ResourceLocation getTexture() {
            if (this.output > 0) {
                return GateBlock.getOnTexture(this.name);
            }
            return GateBlock.getOffTexture(this.name);
        }

        public boolean onNeighborChange(@Nullable BlockPos neighbor) {
            int front;
            int back;
            int right;
            Direction leftDirection = this.getDirectionFromSide(Side.LEFT);
            Direction rightDirection = this.getDirectionFromSide(Side.RIGHT);
            Direction backDirection = this.getDirectionFromSide(Side.BACK);
            Direction frontDirection = this.getDirectionFromSide(Side.FRONT);
            int left = this.m_58904_().m_277185_(this.m_58899_().m_121945_(leftDirection), leftDirection);
            int output = GateBlock.this.runLogicOnSites(left, right = this.m_58904_().m_277185_(this.m_58899_().m_121945_(rightDirection), rightDirection), back = this.m_58904_().m_277185_(this.m_58899_().m_121945_(backDirection), backDirection), front = this.m_58904_().m_277185_(this.m_58899_().m_121945_(frontDirection), frontDirection));
            if (output != this.output) {
                this.output = output;
                return true;
            }
            return false;
        }
    }

    public class VariantBlock
    extends AbstractGateBlock {
        String name;

        public VariantBlock(String name) {
            this.name = name;
        }

        protected AbstractGateBlockEntity newAbstractGateBlockEntity(BlockPos pos, BlockState state) {
            return new VariantBlockEntity(pos, state, this.name);
        }

        public boolean canConnectRedstone(Side side) {
            return side == Side.LEFT || side == Side.RIGHT || side == Side.FRONT;
        }
    }
}

